package ru.yandex.chemodan.app.psbilling.core.dao.groups;

import java.math.BigDecimal;
import java.util.Currency;
import java.util.UUID;

import javax.annotation.Nonnull;

import lombok.Builder;
import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.AbstractDao;
import ru.yandex.chemodan.app.psbilling.core.dao.InsertingData;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.GroupPaymentType;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.GroupProductEntity;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.GroupProductType;
import ru.yandex.chemodan.app.psbilling.core.products.GroupProduct;
import ru.yandex.misc.lang.DefaultObject;

public interface GroupProductDao extends AbstractDao<GroupProductEntity> {

    GroupProductEntity insert(InsertData dataToInsert);

    ListF<GroupProductEntity> findByProductLine(UUID lineId);

    Option<GroupProductEntity> findProductByCode(@Nonnull String code);

    ListF<GroupProductEntity> findAvailableAddons(UUID groupProductId);

    ListF<GroupProductEntity> findEligibleMainProducts(UUID mainProductId);

    ListF<GroupProductEntity> findByIds(CollectionF<UUID> productIds);

    ListF<GroupProductEntity> findByProductCodes(ListF<String> codes);

    GroupProductEntity findByGroupServiceId(UUID groupServiceId);

    void linkAddon(GroupProduct main, GroupProduct addon);

    void unlinkAddon(GroupProduct main, GroupProduct addon);

    @Getter
    @Builder
    class InsertData extends DefaultObject implements InsertingData<GroupProductEntity> {
        private final String code;
        private final UUID userProduct;
        @Builder.Default
        private final Option<String> balanceProductName = Option.empty();
        private final BigDecimal pricePerUserInMonth;
        @Builder.Default
        private final Option<BigDecimal> displayOriginalPrice = Option.empty();
        private final Currency priceCurrency;
        private final boolean singleton;
        private final boolean skipTransactionsExport;
        @Builder.Default
        private final Option<UUID> trialDefinitionId = Option.empty();
        @Builder.Default
        private final Option<Instant> availableTo = Option.empty();
        private final boolean hidden;
        @Builder.Default
        private final Option<UUID> titleTankerKeyId = Option.empty();
        private final boolean isBestOffer;
        private final GroupPaymentType paymentType;
        private final GroupProductType productType;
        @Builder.Default
        private final Option<BigDecimal> displayDiscountPercent = Option.empty();
    }
}
