package ru.yandex.chemodan.app.psbilling.core.dao.groups;

import java.util.Currency;
import java.util.UUID;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.Interval;
import org.joda.time.LocalDate;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.AbstractDao;
import ru.yandex.chemodan.app.psbilling.core.dao.InsertingData;
import ru.yandex.chemodan.app.psbilling.core.dao.features.ServiceDao;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.GroupPaymentType;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.GroupService;
import ru.yandex.chemodan.app.psbilling.core.synchronization.engine.ParentSynchronizableRecordDao;
import ru.yandex.chemodan.app.psbilling.core.synchronization.engine.Target;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.time.InstantInterval;

public interface GroupServiceDao extends ServiceDao, AbstractDao<GroupService>,
        ParentSynchronizableRecordDao<GroupService> {

    GroupService insert(InsertData insertData);

    ListF<GroupService> find(UUID groupId, UUID productId);

    ListF<GroupService> find(UUID groupId, Target... targets);

    default ListF<GroupService> find(ListF<UUID> groupIds, Target... targets) {
        return find(groupIds, false, targets);
    }

    ListF<GroupService> find(UUID groupId, boolean withSubgroups, Target... targets);

    ListF<GroupService> find(ListF<UUID> groupIds, boolean withSubgroups, Target... targets);

    ListF<GroupService> findGroupServicesToSync(UUID groupId);

    ListF<GroupService> findActiveGroupServicesByPaymentInfoClient(Long clientId, Currency currency);

    ListF<UUID> groupIdsToSync();

    GroupService updateSkipTransactionsExport(UUID groupServiceId, boolean skipTransactionsExport);

    boolean setTargetToDisabled(UUID groupServiceId, Target oldState);

    MapF<GroupService, ListF<Interval>> getEnabledUserServicesInDayPaidIntervals(LocalDate date, Page page);

    MapF<GroupService, ListF<Interval>> getEnabledUserServicesInDayPaidIntervals(
            LocalDate date, ListF<GroupService> groupServices);

    Option<Page> nextPageOfActiveServicesOnDay(LocalDate date, Option<UUID> greaterThan, int batchSize);

    ListF<GroupService> findActiveServicesOnDayForClient(LocalDate date, Long clientId);

    void updateNextBillingDate(UUID groupServiceId, Option<Instant> nextBillingDateO);

    void updatePrepaidNextBillingDateForClient(Long clientId, Currency currency, Option<Instant> nextBillingDateO);

    ListF<GroupService> findGroupServices(ListF<UUID> groupServiceIds);

    ListF<GroupService> findActiveGroupServicesByPaymentType(ListF<UUID> groupIds, GroupPaymentType paymentType);

    ListF<GroupService> findGroupServicesWithNotHiddenTrialOverrideEndDateInBetween(Instant afterInclusive,
                                                                                    Instant beforeExclusive,
                                                                                    int batchSize,
                                                                                    Option<UUID> groupServiceIdMin);

    ListF<GroupService> findActiveGroupServicesCreatedInBetween(InstantInterval interval, Option<UUID> groupIdMin,
                                                                int batchSize);

    default int countNotActualUpdatedBefore(Duration triggeredBefore) {
        return getParentSynchronizableRecordDaoHelper().countNotActualUpdatedBefore(triggeredBefore, true);
    }

    int getMistakenlyActiveServiceCount(Duration threshold);

    ListF<GroupService> findLastDisabledPrepaidServices(long clientId, Currency currency);

    @Getter
    @Builder
    class InsertData extends DefaultObject implements InsertingData<GroupService> {
        private UUID groupId;
        private UUID productId;
        private Target target;
        private Option<Instant> nextBDate;
        private String deduplicationKey;
        private boolean skipTransactionsExport;
        private boolean hidden;
    }

    @Getter
    @AllArgsConstructor
    class Page extends DefaultObject {
        private UUID min;
        private UUID max;
    }
}
