package ru.yandex.chemodan.app.psbilling.core.dao.groups;

import java.util.UUID;

import lombok.Builder;
import lombok.Getter;

import ru.yandex.chemodan.app.psbilling.core.dao.AbstractDao;
import ru.yandex.chemodan.app.psbilling.core.dao.InsertingData;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.GroupServiceMember;
import ru.yandex.chemodan.app.psbilling.core.synchronization.engine.ChildSynchronizableRecordDao;
import ru.yandex.chemodan.app.psbilling.core.synchronization.engine.ParentSynchronizableRecordDao;
import ru.yandex.misc.lang.DefaultObject;

public interface GroupServiceMemberDao extends AbstractDao<GroupServiceMember>,
        ChildSynchronizableRecordDao<GroupServiceMember, GroupServiceMemberDao.InsertData>,
        ParentSynchronizableRecordDao<GroupServiceMember> {
    void updateUserServiceId(UUID id, UUID userServiceId);

    int getEnabledMembersCount(UUID userServiceId);

    @Getter
    @Builder
    class InsertData extends DefaultObject implements InsertingData<GroupServiceMember> {
        private final UUID groupServiceId;
        private final String uid;
    }
}
