package ru.yandex.chemodan.app.psbilling.core.dao.groups;

import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

import lombok.Builder;
import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.AbstractDao;
import ru.yandex.chemodan.app.psbilling.core.dao.InsertingData;
import ru.yandex.chemodan.app.psbilling.core.entities.AbstractEntity;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.GroupService;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.GroupServicePriceOverride;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.PriceOverrideReason;
import ru.yandex.misc.lang.DefaultObject;

public interface GroupServicePriceOverrideDao extends AbstractDao<GroupServicePriceOverride> {
    GroupServicePriceOverride insert(InsertData data);

    MapF<UUID, ListF<GroupServicePriceOverride>> findByGroupServices(ListF<UUID> groupServiceIds);

    default MapF<UUID, ListF<GroupServicePriceOverride>> findByGroupServices(List<GroupService> groupServices) {
        ListF<UUID> ids = Cf.toList(groupServices.stream().map(AbstractEntity::getId).collect(Collectors.toList()));
        return findByGroupServices(ids);
    }

    @Getter
    @Builder
    class InsertData extends DefaultObject implements InsertingData<GroupServicePriceOverride> {
        private UUID groupServiceId;
        private BigDecimal pricePerUserInMonth;
        private Instant startDate;
        private Option<Instant> endDate;
        private Option<UUID> trialUsageId;
        private PriceOverrideReason reason;
        private boolean hidden;
    }

}
