package ru.yandex.chemodan.app.psbilling.core.dao.groups;


import org.joda.time.LocalDate;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.billing.CalculationStatus;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.billing.GroupServiceTransactionCalculation;

public interface GroupServiceTransactionCalculationDao {
    void insertIfAbsent(LocalDate date);

    GroupServiceTransactionCalculation lock(LocalDate date);

    default boolean updateStatus(LocalDate date, CalculationStatus previousStatus, CalculationStatus newStatus) {
        return updateStatus(date, Cf.list(previousStatus), newStatus);
    }

    boolean updateStatus(LocalDate date, CollectionF<CalculationStatus> previousStatuses, CalculationStatus newStatus);

    void saveBazingaJobId(LocalDate date, String jobId);

    LocalDate findLatestCalculation();
}
