package ru.yandex.chemodan.app.psbilling.core.dao.groups;

import java.util.UUID;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.joda.time.LocalDate;

import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.export.YtExportRow;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.billing.GroupServiceTransaction;
import ru.yandex.misc.lang.DefaultObject;

public interface GroupServiceTransactionsDao {

    void batchInsert(CollectionF<GroupServiceTransaction> transactions);

    int removeCalculations(LocalDate date, int batchSize);

    ListF<ExportRow> findTransactions(LocalDate date, Option<UUID> groupServiceGreaterThan, int batchSize);

    ListF<GroupServiceTransaction> findGroupTransactions(LocalDate month, UUID groupId);

    ListF<GroupServiceTransaction> findClientTransactionsFrom(LocalDate date, Long clientId);

    ListF<Long> findTransactionsClients(LocalDate billingDate, Option<Long> from, int batchSize);

    @AllArgsConstructor
    @Getter
    class ExportRow extends DefaultObject implements YtExportRow {
        private final String clientId;
        private final String balanceProductName;
        private final GroupServiceTransaction groupServiceTransaction;

        @Override
        public UUID getId() {
            return getGroupServiceTransaction().getGroupServiceId();
        }
    }
}
