package ru.yandex.chemodan.app.psbilling.core.dao.groups;

import java.math.BigDecimal;
import java.util.UUID;

import lombok.Builder;
import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.billing.groups.Money;
import ru.yandex.chemodan.app.psbilling.core.dao.AbstractDao;
import ru.yandex.chemodan.app.psbilling.core.dao.InsertingData;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.billing.GroupTrustPaymentGroupServiceInfo;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.billing.GroupTrustPaymentRequest;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.billing.PaymentInitiationType;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.billing.PaymentRequestStatus;
import ru.yandex.misc.lang.DefaultObject;

public interface GroupTrustPaymentRequestDao extends AbstractDao<GroupTrustPaymentRequest> {

    GroupTrustPaymentRequest insert(InsertData dataToInsert);

    Option<GroupTrustPaymentRequest> updateStatusIfInInit(GroupTrustPaymentRequest groupTrustPaymentRequest);

    Option<GroupTrustPaymentRequest> updateTransactionIdIfNull(UUID id, String purchaseToken);

    Option<GroupTrustPaymentRequest> findByRequestId(String requestId);

    ListF<GroupTrustPaymentRequest> findInitPaymentsOlderThan(Instant olderThan, int batchSize, Option<UUID> idFrom);

    ListF<GroupTrustPaymentRequest> findRecentPayments(Long clientId, Option<Instant> from);

    BigDecimal getRecentAutoPaymentsSum(Instant from, PaymentRequestStatus status);

    BigDecimal getRecentResurrectPaymentsSum(Instant from, PaymentRequestStatus status);

    @Getter
    @Builder
    class InsertData extends DefaultObject implements InsertingData<GroupTrustPaymentRequest> {
        private final String requestId;
        private final PaymentRequestStatus status;
        private final String operatorUid;
        private final PaymentInitiationType paymentInitiationType;
        private final Long clientId;
        private final Money money;

        @Builder.Default
        private final Option<String> transactionId = Option.empty();
        @Builder.Default
        private final Option<String> error = Option.empty();
        @Builder.Default
        private final Option<Double> paymentCoefficient = Option.empty();
        @Builder.Default
        private final Option<GroupTrustPaymentGroupServiceInfo> groupServicesInfo = Option.empty();
        @Builder.Default
        private final Option<UUID> cardId = Option.empty();
    }
}
