package ru.yandex.chemodan.app.psbilling.core.dao.groups;

import java.math.BigDecimal;
import java.util.UUID;

import lombok.Builder;
import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.AbstractDao;
import ru.yandex.chemodan.app.psbilling.core.dao.InsertingData;
import ru.yandex.chemodan.app.psbilling.core.entities.CustomPeriodUnit;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.TrialDefinitionEntity;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.TrialType;
import ru.yandex.misc.lang.DefaultObject;

public interface TrialDefinitionDao extends AbstractDao<TrialDefinitionEntity> {

    TrialDefinitionEntity insert(InsertData insertData);

    ListF<TrialDefinitionEntity> findByIds(ListF<UUID> ids);

    @Getter
    @Builder
    class InsertData extends DefaultObject implements InsertingData<TrialDefinitionEntity> {
        private final TrialType type;
        private final boolean hidden;
        private final BigDecimal price;

        @Builder.Default
        private final Option<Instant> endDate = Option.empty(); //for TrialType = UNTIL_DATE
        @Builder.Default
        private final Option<Integer> duration = Option.empty(); //for TrialType = CONSTANT_PERIOD
        @Builder.Default
        private final Option<CustomPeriodUnit> durationMeasurement = Option.empty(); //for TrialType = CONSTANT_PERIOD
        @Builder.Default
        private final Option<String> singleUsageComparisonKey = Option.empty();
    }

}
