package ru.yandex.chemodan.app.psbilling.core.dao.groups;

import java.util.UUID;

import lombok.Builder;
import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.AbstractDao;
import ru.yandex.chemodan.app.psbilling.core.dao.InsertingData;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.TrialUsage;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.lang.DefaultObject;

public interface TrialUsageDao extends AbstractDao<TrialUsage> {
    TrialUsage insert(InsertData insertData);

    ListF<TrialUsage> findTrialUsages(Option<UUID> groupIdO, Option<PassportUid> uidO, String trialUsageComparisonKey);
    ListF<TrialUsage> findByTrialDefinitionAndGroup(UUID trialDefinitionId, UUID groupId);

    @Getter
    @Builder
    class InsertData extends DefaultObject implements InsertingData<TrialUsage> {
        @Builder.Default
        private final Option<UUID> groupId = Option.empty();
        @Builder.Default
        private final Option<PassportUid> activatedByUid = Option.empty();
        private final UUID trialDefinitionId;
        private final Instant endDate;
    }
}
