package ru.yandex.chemodan.app.psbilling.core.dao.groups.billing;

import java.math.BigDecimal;
import java.util.Currency;
import java.util.UUID;

import lombok.Builder;
import lombok.Getter;
import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.chemodan.app.psbilling.core.dao.AbstractDao;
import ru.yandex.chemodan.app.psbilling.core.dao.InsertingData;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.Group;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.GroupService;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.billing.ClientBalanceEntity;
import ru.yandex.misc.lang.DefaultObject;

public interface ClientBalanceDao extends AbstractDao<ClientBalanceEntity> {
    ClientBalanceEntity insert(InsertData dataToInsert);

    Option<ClientBalanceEntity> find(Long clientId, Currency currency);

    Option<ClientBalanceEntity> findByGroupService(GroupService groupService);

    ListF<ClientBalanceEntity> findByGroup(Group group);

    ClientBalanceEntity updateBalance(UUID id, BigDecimal balanceAmount);

    ClientBalanceEntity updateVoidAt(UUID id, Option<Instant> balanceVoidAt);

    ClientBalanceEntity updateInvoiceDate(UUID id, Option<Instant> lastInvoiceAt);

    ClientBalanceEntity createOrUpdate(Long clientId, Currency currency, BigDecimal balanceAmount,
                                       Option<Instant> balanceVoidAt);

    ListF<Long> findObsoleteBalanceClients(Instant oldBalanceDate, Instant oldInvoiceDate, Option<Long> greaterThan,
                                           int batchSize);

    int prepaidDebtsCount();

    int countNotActualUpdatedBefore(Duration duration);

    ListF<Tuple2<Long, Currency>> findClientsForAutoPay(Instant balanceVoidBefore, int batchSize, Option<Tuple2<Long,
            Currency>> greaterThan);

    ListF<Tuple2<Long, Currency>> findClientsForAutoResurrectionPay(
            Instant balanceVoidAfter, Instant lastTryMinTime,
            double lastPaymentCoefficient, int batchSize,
            Option<Tuple2<Long, Currency>> greaterThan);

    @Getter
    @Builder
    class InsertData extends DefaultObject implements InsertingData<ClientBalanceEntity> {
        private final Long clientId;
        private final BigDecimal balanceAmount;
        private final Currency balanceCurrency;
        @Builder.Default
        private final Option<Instant> balanceVoidAt = Option.empty();
        @Builder.Default
        private final Option<Instant> lastInvoiceAt = Option.empty();
    }
}
