package ru.yandex.chemodan.app.psbilling.core.dao.groups.impl;

import java.sql.ResultSet;
import java.sql.SQLException;

import lombok.AllArgsConstructor;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.BucketContentDao;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

@AllArgsConstructor
public class BucketContentDaoImpl implements BucketContentDao {
    protected final JdbcTemplate3 jdbcTemplate;

    @Override
    public ListF<SetF<String>> getBuckets() {
        ListF<RowBucket> list = jdbcTemplate.query(
                "select gp.code, bc.bucket_code " +
                        "from bucket_content bc " +
                        "join group_products gp on gp.id = bc.group_product_id " +
                        "order by bc.bucket_code",
                (rs, rowNum) -> parseRow(rs));
        return list.groupByMapValues(RowBucket::getBucketCode, RowBucket::getProductCode).values().map(ListF::unique);
    }

    @Override
    public void addRowBucket(String bucketCode, String productCode) {
        jdbcTemplate.update("insert into bucket_content (bucket_code, updated_at, group_product_id) " +
                "values (?, now(), (select id from group_products where code = ?))", bucketCode, productCode);
    }

    public RowBucket parseRow(ResultSet rs) throws SQLException {
        return new RowBucket(rs.getString("bucket_code"), rs.getString("code"));
    }

    static class RowBucket {
        String bucketCode;
        String productCode;
        RowBucket(String bucketCode, String productCode) {
            this.bucketCode = bucketCode;
            this.productCode = productCode;
        }
        public String getBucketCode() {
            return bucketCode;
        }
        public String getProductCode() {
            return productCode;
        }
    }

}
