package ru.yandex.chemodan.app.psbilling.core.dao.groups.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;

import javax.annotation.Nonnull;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.AbstractDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.groups.GroupPartnerDao;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.GroupPartnerInfo;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

public class GroupPartnerDaoImpl extends AbstractDaoImpl<GroupPartnerInfo> implements GroupPartnerDao {
    public GroupPartnerDaoImpl(JdbcTemplate3 jdbcTemplate) {
        super(jdbcTemplate);
    }

    @Nonnull
    @Override
    public String getTableName() {
        return "group_partner";
    }

    @Override
    public GroupPartnerInfo parseRow(ResultSet rs) throws SQLException {
        return new GroupPartnerInfo(
                UUID.fromString(rs.getString("id")),
                new Instant(rs.getTimestamp("created_at")),
                UUID.fromString(rs.getString("group_id")),
                rs.getString("partner_external_id"));
    }

    @Override
    public void insertPartnerInfoIfNotExists(UUID groupId, String partnerExternalId) {
        MapF<String, Object> params = Cf.hashMap();
        params.put("partner_external_id", partnerExternalId);
        params.put("group_id", groupId);
        params.put("now", Instant.now());
        jdbcTemplate.update("INSERT INTO " + getTableName() +
                " (created_at, group_id, partner_external_id)" +
                " VALUES (:now, :group_id, :partner_external_id)" +
                " ON CONFLICT DO NOTHING", params);
    }

    @Override
    public void updatePartnerInfo(UUID groupId, String partnerExternalId) {
        MapF<String, Object> params = Cf.hashMap();
        params.put("partner_external_id", partnerExternalId);
        params.put("group_id", groupId);
        jdbcTemplate.update("UPDATE " + getTableName() +
                " SET partner_external_id = :partner_external_id" +
                " WHERE group_id = :group_id", params);
    }

    @Override
    public Option<String> getPartnerId(UUID groupId) {
        MapF<String, Object> params = Cf.map("group_id", groupId);
        return jdbcTemplate
                .queryForOption("SELECT partner_external_id FROM " +
                                getTableName() + " WHERE group_id = :group_id",
                        (rs, i) -> rs.getString("partner_external_id"), params);
    }
}
