package ru.yandex.chemodan.app.psbilling.core.dao.groups.model;

import javax.annotation.Nullable;

import lombok.Builder;
import lombok.Value;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;

@Value
@Builder
public class TimeIntervalCondition {

    private final Instant upperBound;

    private final Instant lowerBound;

    @Nullable
    private final String conditionName;

    public String getSqlCondition(String fieldName) {
        return String.format("%1$s <= :%2$s AND %1$s > :%3$s", fieldName,
                getUpperBoundSqlParameterName(), getLowerBoundSqlParameterName());
    }

    public String getLowerBoundSqlParameterName() {
        String prefix = Option.ofNullable(conditionName).map(value -> value + "_").getOrElse("");
        return prefix + "time_lower_bound";
    }

    public String getUpperBoundSqlParameterName() {
        String prefix = Option.ofNullable(conditionName).map(value -> value + "_").getOrElse("");
        return prefix + "time_upper_bound";
    }
}
