package ru.yandex.chemodan.app.psbilling.core.dao.mail;

import java.util.Collection;

import lombok.Builder;
import lombok.Getter;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.mail.EmailTemplateEntity;
import ru.yandex.chemodan.app.psbilling.core.entities.mail.LocalizedEmailTemplateEntity;
import ru.yandex.inside.utils.Language;
import ru.yandex.misc.lang.DefaultObject;

public interface EmailTemplateDao {
    ListF<EmailTemplateEntity> findAll();

    EmailTemplateEntity create(InsertData insertData);

    Option<EmailTemplateEntity> findByKeyO(String key);

    EmailTemplateEntity findByKey(String key);

    void mergeLocalizations(Collection<LocalizedEmailTemplateEntity> localizations);

    ListF<LocalizedEmailTemplateEntity> findLocalizations(String templateKey);

    Option<LocalizedEmailTemplateEntity> findLocalizedEmailTemplate(String templateKey, Language language);

    @Getter
    @Builder
    class InsertData extends DefaultObject {
        private final String key;
        private final String description;
        @Builder.Default
        private final Option<ListF<String>> args = Option.empty();
    }
}

