package ru.yandex.chemodan.app.psbilling.core.dao.mail.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;

import lombok.AllArgsConstructor;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.mail.SentEmailInfoDao;
import ru.yandex.chemodan.app.psbilling.core.entities.mail.SentEmailInfoEntity;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

@AllArgsConstructor
public class SentEmailInfoDaoImpl implements SentEmailInfoDao {
    protected final JdbcTemplate3 jdbcTemplate;
    private static final String SENT_EMAIL_TABLE = "sent_email_info";

    public SentEmailInfoEntity parseRow(ResultSet rs) throws SQLException {
        return new SentEmailInfoEntity(
                UUID.fromString(rs.getString("id")),
                rs.getString("uid"),
                rs.getString("email_template_key"),
                new Instant(rs.getTimestamp("sent_date")));
    }

    @Override
    public SentEmailInfoEntity createOrUpdate(SentEmailInfoDao.InsertData insertData) {
        MapF<String, Object> params = Cf.hashMap();
        params.put("uid", insertData.getUid());
        params.put("emailTemplateKey", insertData.getEmailTemplateKey());
        params.put("now", Instant.now());

        return jdbcTemplate.queryForOption(
                "insert into " + SENT_EMAIL_TABLE +
                        " (sent_date, email_template_key, uid) " +
                        " values (:now, :emailTemplateKey, :uid)" +
                        " ON CONFLICT(uid, email_template_key) DO UPDATE SET sent_date = :now " +
                        " RETURNING *",
                (rs, rowNum) -> parseRow(rs), params).get();
    }

    @Override
    public Option<SentEmailInfoEntity> find(String uid, String emailTemplate) {
        MapF<String, Object> params = Cf.hashMap();
        params.put("uid", uid);
        params.put("emailTemplateKey", emailTemplate);
        return jdbcTemplate.queryForOption(
                "select * from " + SENT_EMAIL_TABLE +
                        " where uid=:uid and email_template_key = :emailTemplateKey",
                (rs, rowNum) -> parseRow(rs), params);
    }
}
