package ru.yandex.chemodan.app.psbilling.core.dao.products;

import java.math.BigDecimal;
import java.util.UUID;

import lombok.Builder;
import lombok.Getter;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.AbstractDao;
import ru.yandex.chemodan.app.psbilling.core.dao.InsertingData;
import ru.yandex.chemodan.app.psbilling.core.entities.products.FeatureScope;
import ru.yandex.chemodan.app.psbilling.core.entities.products.ProductFeatureEntity;
import ru.yandex.misc.lang.DefaultObject;

public interface ProductFeatureDao extends AbstractDao<ProductFeatureEntity> {
    ProductFeatureEntity insert(InsertData dataToInsert);

    default ListF<ProductFeatureEntity> findEnabledByUserProduct(UUID userProductId) {
        return findEnabledByUserProductIds(Cf.list(userProductId)).getO(userProductId).getOrElse(Cf.list());
    }

    MapF<UUID, ListF<ProductFeatureEntity>> findEnabledByUserProductIds(ListF<UUID> userProductIds);

    ListF<ProductFeatureEntity> findByIds(CollectionF<UUID> ids);

    void disable(UUID productFeatureId);

    @Getter
    @Builder
    class InsertData extends DefaultObject implements InsertingData<ProductFeatureEntity> {
        private final Option<UUID> featureId;
        private final UUID userProductId;
        private final BigDecimal amount;
        private final int orderNum;
        private final Option<UUID> descriptionTankerKeyId;
        private final Option<UUID> valueTankerKeyId;
        private final String code;
        private final FeatureScope scope;
    }
}
