package ru.yandex.chemodan.app.psbilling.core.dao.products;

import java.util.UUID;

import lombok.Builder;
import lombok.Getter;

import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.AbstractDao;
import ru.yandex.chemodan.app.psbilling.core.dao.InsertingData;
import ru.yandex.chemodan.app.psbilling.core.entities.products.ProductLineEntity;
import ru.yandex.misc.lang.DefaultObject;

public interface ProductLineDao extends AbstractDao<ProductLineEntity> {

    ListF<ProductLineEntity> findByProductSetId(UUID productSetId);

    ListF<ProductLineEntity> findByProductSetIds(CollectionF<UUID> productSetIds);

    ListF<ProductLineEntity> findByUserProduct(UUID userProductId);

    ListF<ProductLineEntity> findByGroupProduct(UUID groupProductId);

    void bindUserProducts(UUID productLineId, ListF<UUID> userProductIds);

    void bindGroupProducts(UUID productLineId, ListF<UUID> groupProductIds);

    ProductLineEntity create(InsertData dataToInsert);

    @Getter
    @Builder
    class InsertData extends DefaultObject implements InsertingData<ProductLineEntity> {
        private UUID productSetId;
        private String selectorBeanEL;
        private int orderNum;
        @Builder.Default
        private Option<String> description = Option.empty();
    }
}
