package ru.yandex.chemodan.app.psbilling.core.dao.products;

import java.util.UUID;

import lombok.Builder;
import lombok.Getter;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.AbstractDao;
import ru.yandex.chemodan.app.psbilling.core.dao.InsertingData;
import ru.yandex.chemodan.app.psbilling.core.entities.products.ProductSetEntity;
import ru.yandex.misc.lang.DefaultObject;

public interface ProductSetDao extends AbstractDao<ProductSetEntity> {
    Option<ProductSetEntity> findByKey(String key);

    ProductSetEntity create(InsertData dataToInsert);

    ListF<ProductSetEntity> findByGroupProduct(UUID groupProductId);

    @Getter
    @Builder
    class InsertData extends DefaultObject implements InsertingData<ProductSetEntity> {
        private String key;
    }
}
