package ru.yandex.chemodan.app.psbilling.core.dao.products;

import java.math.BigDecimal;
import java.util.UUID;

import lombok.Builder;
import lombok.Getter;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.AbstractDao;
import ru.yandex.chemodan.app.psbilling.core.dao.InsertingData;
import ru.yandex.chemodan.app.psbilling.core.entities.products.ProductTemplateFeatureEntity;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author friendlyevil
 */
public interface ProductTemplateFeatureDao extends AbstractDao<ProductTemplateFeatureEntity> {

    ProductTemplateFeatureEntity insert(InsertData insertData);

    Option<ProductTemplateFeatureEntity> findByProductFeatureId(UUID productFeatureId);

    @Getter
    @Builder
    class InsertData extends DefaultObject implements InsertingData<ProductTemplateFeatureEntity> {
        private final UUID productTemplateId;
        @Builder.Default
        private final Option<UUID> featureId = Option.empty();
        private final BigDecimal amount;
        private final int orderNum;
        @Builder.Default
        private final Option<UUID> descriptionTankerKeyId = Option.empty();
        private final String code;
    }
}
