package ru.yandex.chemodan.app.psbilling.core.dao.products;

import java.util.UUID;

import lombok.Builder;
import lombok.Getter;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.app.psbilling.core.dao.AbstractDao;
import ru.yandex.chemodan.app.psbilling.core.dao.InsertingData;
import ru.yandex.chemodan.app.psbilling.core.entities.products.UserProductBucketEntity;
import ru.yandex.chemodan.app.psbilling.core.entities.products.UserProductPriceEntity;
import ru.yandex.misc.lang.DefaultObject;

public interface UserProductBucketDao extends AbstractDao<UserProductBucketEntity> {

    MapF<String, SetF<UUID>> getUserProductBuckets();

    void addToBucket(InsertData insertData);

    @Getter
    @Builder
    class InsertData extends DefaultObject implements InsertingData<UserProductPriceEntity> {
        private final String code;
        private final Option<UUID> userProductId;
        private final Option<UUID> productLineId;
        private final Option<UUID> productSetId;
    }
}
