package ru.yandex.chemodan.app.psbilling.core.dao.products;

import java.util.UUID;

import lombok.Builder;
import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.AbstractDao;
import ru.yandex.chemodan.app.psbilling.core.dao.InsertingData;
import ru.yandex.chemodan.app.psbilling.core.entities.products.BillingType;
import ru.yandex.chemodan.app.psbilling.core.entities.products.UserProductEntity;
import ru.yandex.misc.lang.DefaultObject;

public interface UserProductDao extends AbstractDao<UserProductEntity> {
    Option<UserProductEntity> findByCodeO(String code);

    UserProductEntity findByCode(String code);

    UserProductEntity insert(InsertData dataToInsert);

    ListF<UserProductEntity> findByProductLine(UUID lineId);

    ListF<UserProductEntity> findByIds(ListF<UUID> userProductIds);

    ListF<UserProductEntity> findByBillingTypes(BillingType... billingTypes);

    UserProductEntity findByGroupServiceId(UUID groupServiceId);

    @Getter
    @Builder
    class InsertData extends DefaultObject implements InsertingData<UserProductEntity> {
        private final String code;
        private final String codeFamily;
        private final UUID titleTankerKeyId;
        private final BillingType billingType;
        private final boolean isBestOffer;
        private final UUID productOwnerId;
        private final Option<Instant> availableForm;
        private final boolean allowAutoProlong;
        /**
         * 1D, 1M, 666Y
         * https://wiki.yandex-team.ru/TRUST/Payments/API/Subscriptions/#mnogokratnyepopytkispisanijasraznicejjvneskolkochasovvtecheniegrejjs-perioda
         */
        private final Option<String> trustSubsGracePeriod;
        /**
         * 1D, 1M, 666Y
         */
        private final Option<String> trustSubsChargingRetryDelay;
        /**
         * 1D, 1M, 666Y
         */
        private final Option<String> trustSubsChargingRetryLimit;
        private final boolean singleton;
        private final Option<Integer> trustServiceId;
        private final Option<UUID> trialDefinitionId;
    }
}
