package ru.yandex.chemodan.app.psbilling.core.dao.products;

import java.util.UUID;

import lombok.Builder;
import lombok.Getter;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.AbstractDao;
import ru.yandex.chemodan.app.psbilling.core.dao.InsertingData;
import ru.yandex.chemodan.app.psbilling.core.entities.CustomPeriod;
import ru.yandex.chemodan.app.psbilling.core.entities.CustomPeriodUnit;
import ru.yandex.chemodan.app.psbilling.core.entities.products.UserProductPeriodEntity;
import ru.yandex.misc.lang.DefaultObject;

public interface UserProductPeriodDao extends AbstractDao<UserProductPeriodEntity> {

    UserProductPeriodEntity create(InsertData dataToInsert);

    ListF<UserProductPeriodEntity> findByIds(ListF<UUID> ids);

    default ListF<UserProductPeriodEntity> findByUserProduct(UUID userProductId) {
        return findByUserProductIds(Cf.list(userProductId)).getOrElse(userProductId, Cf.list());
    }

    MapF<UUID, ListF<UserProductPeriodEntity>> findByUserProductIds(ListF<UUID> userProductIds);

    Option<UserProductPeriodEntity> findByCode(String code);

    @Getter
    @Builder
    class InsertData extends DefaultObject implements InsertingData<UserProductPeriodEntity> {
        private final String code;
        private final CustomPeriod period;
        private final UUID userProductId;
        @Builder.Default
        private final Option<String> trustFiscalTitle = Option.empty();
        @Builder.Default
        private final Option<String> packageName = Option.empty();
        @Builder.Default
        private final Option<Integer> startPeriodDurationLength = Option.empty();
        @Builder.Default
        private final Option<CustomPeriodUnit> startPeriodDurationMeasurement = Option.empty();
        @Builder.Default
        private final Option<Integer> startPeriodCount = Option.empty();
    }

}
