package ru.yandex.chemodan.app.psbilling.core.dao.products;

import java.math.BigDecimal;
import java.util.UUID;

import lombok.Builder;
import lombok.Getter;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.AbstractDao;
import ru.yandex.chemodan.app.psbilling.core.dao.InsertingData;
import ru.yandex.chemodan.app.psbilling.core.entities.products.UserProductPriceEntity;
import ru.yandex.misc.lang.DefaultObject;

public interface UserProductPricesDao extends AbstractDao<UserProductPriceEntity> {

    MapF<UUID, ListF<UserProductPriceEntity>> findByPeriodIds(ListF<UUID> userProductIds);

    default ListF<UserProductPriceEntity> findByPeriodId(UUID userPeriodId) {
        return findByPeriodIds(Cf.list(userPeriodId)).getOrElse(userPeriodId, Cf.list());
    }

    UserProductPriceEntity create(InsertData dataToInsert);

    ListF<UserProductPriceEntity> findByIds(ListF<UUID> ids);

    ListF<UserProductPriceEntity> findPricesByPeriodCode(String userPeriodCode);

    @Getter
    @Builder
    class InsertData extends DefaultObject implements InsertingData<UserProductPriceEntity> {
        private final UUID userProductPeriodId;
        private final String regionId;
        private final BigDecimal price;
        private final String currencyCode;
        private final Option<BigDecimal> displayDiscountPercent;
        private final Option<BigDecimal> displayOriginalPrice;
        private final Option<BigDecimal> startPeriodPrice;
    }
}
