package ru.yandex.chemodan.app.psbilling.core.dao.products.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.AbstractDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.products.ProductSetDao;
import ru.yandex.chemodan.app.psbilling.core.entities.products.ProductSetEntity;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

public class ProductSetDaoImpl extends AbstractDaoImpl<ProductSetEntity> implements ProductSetDao {

    public ProductSetDaoImpl(JdbcTemplate3 jdbcTemplate) {
        super(jdbcTemplate);
    }

    @Override
    public ProductSetEntity create(InsertData dataToInsert) {
        Instant now = Instant.now();
        MapF<String, Object> params = Cf.hashMap();
        params.put("key", dataToInsert.getKey());
        params.put("now", now);

        return jdbcTemplate.queryForOption(
                "insert into product_sets (key, created_at) values (:key, :now) RETURNING *",
                (rs, rowNum) -> parseRow(rs), params).get();
    }

    @Override
    public ListF<ProductSetEntity> findByGroupProduct(UUID groupProductId) {
        return jdbcTemplate.query(
                "select ps.* from group_products_to_product_lines gp2pl " +
                        "join product_lines pl on pl.id = gp2pl.product_line_id " +
                        "join product_sets ps on ps.id = pl.product_set_id " +
                        "where gp2pl.group_product_id = :groupProductId",
                (rs, rowNum) -> parseRow(rs), Cf.map("groupProductId", groupProductId)
        );
    }

    @Override
    public String getTableName() {
        return "product_sets";
    }

    @Override
    public ProductSetEntity parseRow(ResultSet rs) throws SQLException {
        return new ProductSetEntity(
                UUID.fromString(rs.getString("id")),
                new Instant(rs.getTimestamp("created_at")),
                rs.getString("key")
        );
    }

    @Override
    public Option<ProductSetEntity> findByKey(String key) {
        return jdbcTemplate.queryForOption("select * from product_sets where key = ?",
                (rs, rowNum) -> parseRow(rs), key);
    }
}
