package ru.yandex.chemodan.app.psbilling.core.dao.products.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.psbilling.core.dao.AbstractDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.products.ProductTemplateDao;
import ru.yandex.chemodan.app.psbilling.core.entities.products.ProductTemplateEntity;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

/**
 * @author friendlyevil
 */
public class ProductTemplateDaoImpl extends AbstractDaoImpl<ProductTemplateEntity> implements ProductTemplateDao {
    public ProductTemplateDaoImpl(JdbcTemplate3 jdbcTemplate) {
        super(jdbcTemplate);
    }

    @Override
    public ProductTemplateEntity insert(String templateCode) {
        return jdbcTemplate.query("insert into product_templates (code) values (:code) RETURNING *",
                (rs, num) -> parseRow(rs), Cf.map("code", templateCode)).first();
    }

    @Override
    public String getTableName() {
        return "product_templates";
    }

    @Override
    public ProductTemplateEntity parseRow(ResultSet rs) throws SQLException {
        return new ProductTemplateEntity(
                UUID.fromString(rs.getString("id")),
                new Instant(rs.getTimestamp("created_at")),
                rs.getString("code")
        );
    }
}
