package ru.yandex.chemodan.app.psbilling.core.dao.products.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.app.psbilling.core.dao.AbstractDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.products.UserProductBucketDao;
import ru.yandex.chemodan.app.psbilling.core.entities.products.UserProductBucketEntity;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

public class UserProductBucketDaoImpl extends AbstractDaoImpl<UserProductBucketEntity> implements UserProductBucketDao {

    public UserProductBucketDaoImpl(JdbcTemplate3 jdbcTemplate) {
        super(jdbcTemplate);
    }

    @Override
    public String getTableName() {
        return "user_product_buckets";
    }

    @Override
    public UserProductBucketEntity parseRow(ResultSet rs) throws SQLException {
        String userProductId = rs.getString("user_product_id");
        String productLineId = rs.getString("product_line_id");
        String productSetId = rs.getString("product_set_id");
        return new UserProductBucketEntity(
                UUID.fromString(rs.getString("id")),
                new Instant(rs.getTimestamp("created_at")),
                rs.getString("code"),
                StringUtils.isNotBlank(userProductId) ? Option.of(UUID.fromString(userProductId)) : Option.empty(),
                StringUtils.isNotBlank(productLineId) ? Option.of(UUID.fromString(productLineId)) : Option.empty(),
                StringUtils.isNotBlank(productSetId) ? Option.of(UUID.fromString(productSetId)) : Option.empty()
        );
    }

    @Override
    public MapF<String, SetF<UUID>> getUserProductBuckets() {
        return jdbcTemplate.queryForList2(
                "select code, user_product_id from user_product_buckets where user_product_id is not null" +
                        " union all " +
                        " select b.code, l.user_product_id from user_product_buckets b join user_products_to_product_lines l" +
                        "       on b.product_line_id = l.product_line_id " +
                        " union all " +
                        " select b.code, pl.user_product_id from user_product_buckets b " +
                        "       join product_lines l on l.product_set_id = b.product_set_id " +
                        "       join user_products_to_product_lines pl on pl.product_line_id = l.id",
                String.class, String.class
        ).map2(UUID::fromString).groupBy1().mapValues(ListF::unique);
    }

    @Override
    public void addToBucket(InsertData insertData) {
        Instant now = Instant.now();
        MapF<String, Object> params = Cf.hashMap();
        params.put("code", insertData.getCode());
        params.put("user_product_id",
                insertData.getUserProductId() != null ? insertData.getUserProductId().getOrNull() : null);
        params.put("product_line_id",
                insertData.getProductLineId() != null ? insertData.getProductLineId().getOrNull() : null);
        params.put("product_set_id",
                insertData.getProductSetId() != null ? insertData.getProductSetId().getOrNull() : null);
        params.put("now", now);

        jdbcTemplate.update(
                "insert into user_product_buckets (created_at,code,user_product_id,product_line_id,product_set_id) " +
                        "values(:now,:code, :user_product_id, :product_line_id, :product_set_id)", params);
    }
}
