package ru.yandex.chemodan.app.psbilling.core.dao.promocodes;

import java.util.UUID;

import lombok.Builder;
import lombok.Data;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.AbstractPKBasedDAO;
import ru.yandex.chemodan.app.psbilling.core.entities.promocodes.GroupPromoCodeActivationEntity;
import ru.yandex.chemodan.app.psbilling.core.promocodes.model.SafePromoCode;
import ru.yandex.inside.passport.PassportUid;

public interface GroupPromoCodeActivationDao extends AbstractPKBasedDAO<GroupPromoCodeActivationEntity, UUID> {
    GroupPromoCodeActivationEntity create(InsertData dataToInsert);

    Option<GroupPromoCodeActivationEntity> findByGroupIdAndPromoCode(SafePromoCode code, UUID groupId);

    @Data
    @Builder
    class InsertData {
        private final SafePromoCode code;
        private final PassportUid uid;
        private final UUID groupId;
        private final UUID groupPromoId;
    }
}
