package ru.yandex.chemodan.app.psbilling.core.dao.promocodes;

import java.util.UUID;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.AbstractPKBasedDAO;
import ru.yandex.chemodan.app.psbilling.core.entities.promocodes.PromoCodeEntity;
import ru.yandex.chemodan.app.psbilling.core.entities.promocodes.PromoCodeStatus;
import ru.yandex.chemodan.app.psbilling.core.entities.promocodes.PromoCodeType;
import ru.yandex.chemodan.app.psbilling.core.promocodes.model.SafePromoCode;


public interface PromoCodeDao extends AbstractPKBasedDAO<PromoCodeEntity, SafePromoCode> {
    void create(InsertData dataToInsert);

    Option<PromoCodeEntity> findByIdAndTypeO(SafePromoCode promoCode, PromoCodeType type);

    PromoCodeEntity decrementRemainingActivations(SafePromoCode code);

    long calculateNumOccupied(String prefix, long postfixLength);

    CollectionF<SafePromoCode> getConflictingCodes(CollectionF<SafePromoCode> toCheck);

    PromoCodeEntity blockCode(SafePromoCode promoCode, String reason);

    @Getter
    @Builder
    @AllArgsConstructor
    class InsertData {
        private ListF<SafePromoCode> codes;
        @Builder.Default
        private Option<UUID> productPriceId = Option.empty();
        @Builder.Default
        private Option<UUID> promoTemplateId = Option.empty();
        @Builder.Default
        private Option<Integer> numActivations = Option.empty();
        @Builder.Default
        private Option<Integer> remainingActivations = Option.empty();
        @Builder.Default
        private PromoCodeStatus promoCodeStatus = PromoCodeStatus.ACTIVE;
        @Builder.Default
        private Instant statusUpdatedAt = Instant.now();
        @Builder.Default
        private Option<String> statusReason = Option.empty();
        @Builder.Default
        private Instant fromDate = Instant.now();
        @Builder.Default
        private Option<Instant> toDate = Option.empty();
        private PromoCodeType promoCodeType;
        private String templateCode;
    }
}
