package ru.yandex.chemodan.app.psbilling.core.dao.promocodes;

import java.util.UUID;

import lombok.Builder;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.AbstractPKBasedDAO;
import ru.yandex.chemodan.app.psbilling.core.entities.promocodes.PromoCodeTemplateEntity;
import ru.yandex.chemodan.app.psbilling.core.entities.promocodes.PromoCodeType;

public interface PromoCodeTemplateDao extends AbstractPKBasedDAO<PromoCodeTemplateEntity, String> {
    PromoCodeTemplateEntity create(InsertData dataToInsert);

    @Getter
    @RequiredArgsConstructor
    @Builder
    class InsertData {
        private final String code;
        private final PromoCodeType type;
        @Builder.Default
        private final Option<UUID> userProductPriceId = Option.empty();
        @Builder.Default
        private final Option<UUID> promoTemplateId = Option.empty();
        private final String ruleCheckerBeanEl;
        private final String description;
        private final Instant fromDate;
        @Builder.Default
        private final Option<Instant> toDate = Option.empty();
        @Builder.Default
        private final Option<Integer> numActivations = Option.empty();
    }
}
