package ru.yandex.chemodan.app.psbilling.core.dao.promocodes;

import java.util.UUID;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.AbstractPKBasedDAO;
import ru.yandex.chemodan.app.psbilling.core.entities.promocodes.UserPromoCodeEntity;
import ru.yandex.chemodan.app.psbilling.core.promocodes.model.SafePromoCode;
import ru.yandex.inside.passport.PassportUid;

public interface UserPromoCodeDao extends AbstractPKBasedDAO<UserPromoCodeEntity, UUID> {
    UserPromoCodeEntity create(InsertData dataToInsert);

    Option<UserPromoCodeEntity> findByCodeAndUid(SafePromoCode code, PassportUid uid);

    @Getter
    @Builder
    @AllArgsConstructor
    class InsertData {
        SafePromoCode code;
        PassportUid uid;
        @Builder.Default
        Option<UUID> orderId = Option.empty();
        @Builder.Default
        Option<UUID> userPromoId = Option.empty();
    }
}
