package ru.yandex.chemodan.app.psbilling.core.dao.promocodes.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;

import org.intellij.lang.annotations.Language;
import org.joda.time.Instant;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.AbstractPKBasedDAOImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.promocodes.GroupPromoCodeActivationDao;
import ru.yandex.chemodan.app.psbilling.core.entities.promocodes.GroupPromoCodeActivationEntity;
import ru.yandex.chemodan.app.psbilling.core.promocodes.model.SafePromoCode;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

public class GroupPromoCodeActivationDaoImpl
        extends AbstractPKBasedDAOImpl<GroupPromoCodeActivationEntity, UUID>
        implements GroupPromoCodeActivationDao {

    public GroupPromoCodeActivationDaoImpl(JdbcTemplate3 jdbcTemplate) {
        super(jdbcTemplate);
    }

    @Override
    public String getTableName() {
        return "group_promo_code_activations";
    }

    public GroupPromoCodeActivationEntity create(InsertData dataToInsert) {
        MapSqlParameterSource params = new MapSqlParameterSource()
                .addValue("code", dataToInsert.getCode())
                .addValue("now", Instant.now())
                .addValue("uid", dataToInsert.getUid())
                .addValue("group_id", dataToInsert.getGroupId())
                .addValue("group_promo_id", dataToInsert.getGroupPromoId());

        @Language("SQL")
        String sql = "insert into " + getTableName() +
                " (code, uid, created_at, group_id, group_promo_id) " +
                " values (:code, :uid, :now, :group_id, :group_promo_id) " +
                " returning *";

        ListF<GroupPromoCodeActivationEntity> result = jdbcTemplate.query(sql, (rs, num) -> parseRow(rs), params);

        return DataAccessUtils.requiredSingleResult(result);
    }

    @Override
    public Option<GroupPromoCodeActivationEntity> findByGroupIdAndPromoCode(SafePromoCode code, UUID groupId) {
        MapF<String, Object> params = Cf.map(
                "code", code,
                "groupId", groupId
        );

        @Language("SQL")
        String sql = "SELECT * FROM " + getTableName() + " WHERE code = :code AND group_id = :groupId";

        return jdbcTemplate.queryForOption(sql, (rs, rowNum) -> parseRow(rs), params);
    }

    @Override
    public GroupPromoCodeActivationEntity parseRow(ResultSet rs) throws SQLException {
        return new GroupPromoCodeActivationEntity(
                UUID.fromString(rs.getString("id")),
                new Instant(rs.getTimestamp("created_at")),
                SafePromoCode.cons(rs.getString("code")),
                PassportUid.cons(Long.parseLong(rs.getString("uid"))),
                UUID.fromString(rs.getString("group_id")),
                UUID.fromString(rs.getString("group_promo_id"))
        );
    }

    @Override
    protected String pkColumnName() {
        return "id";
    }
}

