package ru.yandex.chemodan.app.psbilling.core.dao.promos;

import java.util.UUID;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.AbstractDao;
import ru.yandex.chemodan.app.psbilling.core.dao.InsertingData;
import ru.yandex.chemodan.app.psbilling.core.entities.promos.PromoPayloadEntity;
import ru.yandex.misc.lang.DefaultObject;


public interface PromoPayloadDao extends AbstractDao<PromoPayloadEntity> {
    PromoPayloadEntity create(PromoPayloadDao.InsertData dataToInsert);

    PromoPayloadEntity createOrUpdate(PromoPayloadDao.InsertData dataToInsert);

    default Option<PromoPayloadEntity> get(UUID promoId, String payloadType, Option<Integer> version) {
        return get(Cf.list(promoId), payloadType, version).getO(promoId);
    }

    MapF<UUID, PromoPayloadEntity> get(ListF<UUID> promoId, String payloadType, Option<Integer> version);

    @Getter
    @Builder
    @AllArgsConstructor
    class InsertData extends DefaultObject implements InsertingData<PromoPayloadEntity> {
        private final UUID promoId;
        private final String payloadType;
        private final String content;
        private final int version;
    }
}
