package ru.yandex.chemodan.app.psbilling.core.dao.promos;

import java.util.Collection;
import java.util.UUID;

import com.google.common.annotations.VisibleForTesting;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.app.psbilling.core.dao.AbstractDao;
import ru.yandex.chemodan.app.psbilling.core.dao.InsertingData;
import ru.yandex.chemodan.app.psbilling.core.entities.CustomPeriod;
import ru.yandex.chemodan.app.psbilling.core.entities.promos.PromoApplicationArea;
import ru.yandex.chemodan.app.psbilling.core.entities.promos.PromoApplicationType;
import ru.yandex.chemodan.app.psbilling.core.entities.promos.PromoTemplateEntity;
import ru.yandex.misc.lang.DefaultObject;

public interface PromoTemplateDao extends AbstractDao<PromoTemplateEntity> {
    PromoTemplateEntity create(InsertData dataToInsert);

    void bindProductLines(UUID promoId, Collection<UUID> productLines);

    default void bindProductLines(UUID promoId, UUID productLine) {
        bindProductLines(promoId, Cf.list(productLine));
    }
    Option<PromoTemplateEntity> findByCode(String code);

    MapF<PromoTemplateEntity, SetF<UUID>> findOnlyB2cWithProductLines();

    MapF<PromoTemplateEntity, SetF<UUID>> findOnlyB2cByProductLines(ListF<UUID> productLine);

    SetF<UUID> getProductLines(UUID promoId);

    @VisibleForTesting
    ListF<PromoTemplateEntity> findByIds(ListF<UUID> promoTemplateIds);


    @Getter
    @Builder
    @AllArgsConstructor
    class InsertData extends DefaultObject implements InsertingData<PromoTemplateEntity> {
        private final String code;
        private final String description;
        private final Instant fromDate;
        @Builder.Default
        private final Option<Instant> toDate = Option.empty();
        private final PromoApplicationArea applicationArea;
        private final PromoApplicationType applicationType;
        @Builder.Default
        private final Option<CustomPeriod> duration = Option.empty();
        @Builder.Default
        private final Option<String> activationEmailTemplate = Option.empty();
        @Builder.Default
        private final Option<UUID> promoNameTankerKey = Option.empty();
    }
}
