package ru.yandex.chemodan.app.psbilling.core.dao.promos;

import java.util.UUID;

import com.google.common.annotations.VisibleForTesting;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.AbstractDao;
import ru.yandex.chemodan.app.psbilling.core.entities.promos.PromoStatusType;
import ru.yandex.chemodan.app.psbilling.core.entities.promos.UserPromoEntity;
import ru.yandex.inside.passport.PassportUid;

public interface UserPromoDao extends AbstractDao<UserPromoEntity> {
    UserPromoEntity createOrUpdate(InsertData data);

    ListF<UserPromoEntity> findUserPromos(PassportUid uid);

    @VisibleForTesting
    ListF<UserPromoEntity> findUserPromos(PassportUid uid, ListF<UUID> productLines);

    Option<UserPromoEntity> findUserPromo(PassportUid uid, UUID promoTemplateId);

    UserPromoEntity setStatus(UUID id, PromoStatusType status);

    @Getter
    @Builder
    @AllArgsConstructor
    class InsertData {
        private final UUID promoTemplateId;
        private final PassportUid uid;
        private final Instant fromDate;
        @Builder.Default
        private final Option<Instant> toDate = Option.empty();
        @Builder.Default
        private final PromoStatusType promoStatusType = PromoStatusType.ACTIVE;
    }
}
