package ru.yandex.chemodan.app.psbilling.core.dao.promos.group;

import java.util.UUID;

import lombok.Builder;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.AbstractDao;
import ru.yandex.chemodan.app.psbilling.core.dao.CreatedOrExistResult;
import ru.yandex.chemodan.app.psbilling.core.entities.promos.group.GroupPromoEntity;
import ru.yandex.chemodan.app.psbilling.core.entities.promos.group.GroupPromoStatusType;
import ru.yandex.chemodan.util.exception.BadRequestException;

public interface GroupPromoDao extends AbstractDao<GroupPromoEntity> {
    CreatedOrExistResult<GroupPromoEntity> createIfNotExist(GroupPromoDao.InsertData data);

    GroupPromoEntity updateById(UUID id, UpdateData data);

    GroupPromoEntity updateStatusById(UUID id, GroupPromoStatusType status);

    ListF<GroupPromoEntity> findByGroupId(UUID groupId);

    Option<GroupPromoEntity> findByGroupIdAndPromoTemplateId(UUID groupId, UUID promoTemplateId);

    @Getter
    @RequiredArgsConstructor
    @Builder(builderClassName = "BuilderWithValid")
    class InsertData {
        private final UUID promoTemplateId;
        private final UUID groupId;
        private final Instant fromDate;
        private final Option<Instant> toDate;
        private final GroupPromoStatusType status;

        public static class BuilderWithValid {
            private Option<Instant> toDate = Option.empty();
            private GroupPromoStatusType status = GroupPromoStatusType.ACTIVE;

            public InsertData build() {
                toDate.ifPresent(d -> {
                    if (d.isBefore(fromDate)) {
                        throw new BadRequestException("to_date can't be before from_date");
                    }
                });

                return new InsertData(promoTemplateId, groupId, fromDate, toDate, status);
            }
        }
    }

    @Getter
    class UpdateData {
        private final Instant fromDate;
        private final Option<Instant> toDate;
        private final GroupPromoStatusType status;

        public UpdateData(Instant fromDate, Option<Instant> toDate, GroupPromoStatusType status) {
            toDate.ifPresent(d -> {
                if (d.isBefore(fromDate)) {
                    throw new BadRequestException("to_date can't be before from_date");
                }
            });
            this.fromDate = fromDate;
            this.toDate = toDate;
            this.status = status;
        }

        public UpdateData(Instant fromDate, GroupPromoStatusType status) {
            this(fromDate, Option.empty(), status);
        }
    }
}
