package ru.yandex.chemodan.app.psbilling.core.dao.promos.group;

import java.util.UUID;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.promos.PromoTemplateWithUsedPromo;
import ru.yandex.chemodan.app.psbilling.core.entities.groups.Group;
import ru.yandex.chemodan.app.psbilling.core.entities.promos.PromoTemplateEntity;
import ru.yandex.chemodan.app.psbilling.core.entities.promos.group.GroupPromoEntity;

public interface GroupPromoTemplateDao {

    MapF<UUID, PromoTemplateEntity> findPromoTemplateForInTimePoint(
            Option<UUID> groupId,
            Option<UUID> additionalPromoId,
            Option<Instant> timePoint
    );

    MapF<PromoTemplateWithUsedPromo<GroupPromoEntity>, ListF<UUID>> findPromoTemplateByProductLine(
            Group group,
            ListF<UUID> lineIds
    );
}
