package ru.yandex.chemodan.app.psbilling.core.dao.texts;

import java.util.UUID;

import lombok.Builder;
import lombok.Getter;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.chemodan.app.psbilling.core.dao.AbstractDao;
import ru.yandex.chemodan.app.psbilling.core.dao.InsertingData;
import ru.yandex.chemodan.app.psbilling.core.entities.texts.TankerKeyEntity;
import ru.yandex.chemodan.app.psbilling.core.entities.texts.TankerTranslationEntity;
import ru.yandex.misc.lang.DefaultObject;

public interface TankerKeyDao extends AbstractDao<TankerKeyEntity> {
    ListF<TankerKeyEntity> findAllKeys();

    MapF<UUID, ListF<TankerTranslationEntity>> findAllTranslations();

    TankerKeyEntity create(InsertData dataToInsert);

    void mergeTranslations(ListF<TankerTranslationEntity> translations);

    Tuple2<UUID, ListF<TankerTranslationEntity>> findTranslations(String tankerProject, String tankerKeyset,
                                                                  String tankerKey);

    ListF<TankerTranslationEntity> findTranslations(UUID tankerKeyId);

    MapF<UUID, ListF<TankerTranslationEntity>> findTranslations(ListF<UUID> tankerKeyIds);

    void insertIfNotExist(String tankerProject, String tankerKeyset,
                          String tankerKey);

    boolean exists(String tankerProject, String tankerKeyset, String tankerKey);

    @Getter
    @Builder
    class InsertData extends DefaultObject implements InsertingData<TankerKeyEntity> {
        private final String project;
        private final String keySet;
        private final String key;
    }
}


