package ru.yandex.chemodan.app.psbilling.core.dao.users;

import java.util.UUID;

import lombok.Builder;
import lombok.Getter;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.springframework.dao.DataIntegrityViolationException;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.AbstractDao;
import ru.yandex.chemodan.app.psbilling.core.dao.InsertingData;
import ru.yandex.chemodan.app.psbilling.core.entities.users.Order;
import ru.yandex.chemodan.app.psbilling.core.entities.users.OrderStatus;
import ru.yandex.chemodan.app.psbilling.core.entities.users.OrderType;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.lang.DefaultObject;

public interface OrderDao extends AbstractDao<Order> {
    /**
     * @deprecated  Потенциально опасная штука. Если нужно создание, использовать {@link #createIfNotExists(InsertData)}
     * Если нужно обновление Order, то использовать отдельный метод с операцией update
     */
    @Deprecated
    Order createOrUpdate(InsertData dataToInsert);

    /**
     * Создает Order с опцией игнорирования конфликта по trust_order_id
     * Если запись присутствует, то возвращает его
     * @param dataToInsert
     * @return Order
     */
    Order createIfNotExists(InsertData dataToInsert);

    /**
     * Создает Order
     * @param dataToInsert
     * @return Order
     * @throws DataIntegrityViolationException if exist
     */
    Order create(InsertData dataToInsert);

    Option<Order> findByTrustOrderId(String trustOrderId);

    ListF<Order> findByServiceId(UUID userServiceId);

    ListF<Order> findByUid(PassportUid uid);

    void writeErrorStatus(UUID orderId, String trustErrorCode, String trustErrorMessage);

    Order changeOrderUid(UUID orderId, String uid);

    void onSuccessfulOrderPurchase(UUID orderId, Option<UUID> userServiceId, int subscriptionsCount);

    void onSuccessfulOrderResume(UUID orderId);

    void updateSubscriptionsCount(UUID orderId, int subscriptionsCount);

    ListF<UUID> findInStatus(OrderStatus orderStatus, Option<UUID> from, int batch);

    int countInitCreatedBefore(Duration createdBefore);

    Order updateOrderPrice(UUID orderId, UUID priceId, int subscriptionsCount);

    Order upgradeOrder(UUID orderId, UUID upgradedOrder);

    Order holdOrder(UUID orderId);

    Order unHoldOrder(UUID orderId);

    Order lock(UUID orderId);

    Order updateInappSyncDate(UUID orderId, Instant syncTime);

    ListF<Order> findInappOrderForMigration(Instant minHoldDate, Instant maxPurchaseDate);

    @Getter
    @Builder
    class InsertData extends DefaultObject implements InsertingData<Order> {
        private UUID userProductPriceId;
        private String uid;
        private OrderType type;
        private String trustOrderId;
        private int trustServiceId;
        private Option<String> packageName;
        private Option<OrderStatus> status;
        @Builder.Default
        private Option<Instant> inappSynchronizationDate = Option.empty();
    }

}
