package ru.yandex.chemodan.app.psbilling.core.dao.users;

import java.util.UUID;

import lombok.Builder;
import lombok.Getter;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.AbstractDao;
import ru.yandex.chemodan.app.psbilling.core.dao.InsertingData;
import ru.yandex.chemodan.app.psbilling.core.entities.users.Refund;
import ru.yandex.chemodan.app.psbilling.core.entities.users.RefundStatus;
import ru.yandex.misc.lang.DefaultObject;

public interface RefundDao extends AbstractDao<Refund> {
    Option<Refund> findByTrustRefundId(String trustRefundId);

    Refund create(InsertData insertData);

    void updateStatus(UUID id, RefundStatus newStatus);

    ListF<Refund> getOrderRefunds(UUID orderId);

    ListF<UUID> findInInitStatus(Option<UUID> from, int batchSize);

    @Getter
    @Builder
    class InsertData extends DefaultObject implements InsertingData<Refund> {
        private final UUID orderId;
        private final String trustPaymentId;
        private final String trustRefundId;
        private final Option<RefundStatus> status;
    }

}
