package ru.yandex.chemodan.app.psbilling.core.dao.users;

import lombok.Builder;
import lombok.Getter;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.AbstractDao;
import ru.yandex.chemodan.app.psbilling.core.dao.InsertingData;
import ru.yandex.chemodan.app.psbilling.core.entities.users.UserInfo;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.lang.DefaultObject;

public interface UserInfoDao extends AbstractDao<UserInfo> {

    UserInfo createOrUpdate(InsertData dataToInsert);

    Option<UserInfo> findByUid(PassportUid uid);

    Option<UserInfo> lockUser(PassportUid uid);

    @Getter
    @Builder
    class InsertData extends DefaultObject implements InsertingData<UserInfo> {
        private final PassportUid uid;
        private final Option<String> regionId;
    }
}
