package ru.yandex.chemodan.app.psbilling.core.dao.users;

import java.util.UUID;

import lombok.Builder;
import lombok.Getter;
import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.AbstractDao;
import ru.yandex.chemodan.app.psbilling.core.dao.InsertingData;
import ru.yandex.chemodan.app.psbilling.core.dao.features.ServiceDao;
import ru.yandex.chemodan.app.psbilling.core.entities.users.OrderStatus;
import ru.yandex.chemodan.app.psbilling.core.entities.users.UserServiceBillingStatus;
import ru.yandex.chemodan.app.psbilling.core.entities.users.UserServiceEntity;
import ru.yandex.chemodan.app.psbilling.core.synchronization.engine.ChildSynchronizableRecordDao;
import ru.yandex.chemodan.app.psbilling.core.synchronization.engine.ParentSynchronizableRecordDao;
import ru.yandex.chemodan.app.psbilling.core.synchronization.engine.Target;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.lang.DefaultObject;

public interface UserServiceDao extends ServiceDao, AbstractDao<UserServiceEntity>,
        ChildSynchronizableRecordDao<UserServiceEntity, UserServiceDao.InsertData>,
        ParentSynchronizableRecordDao<UserServiceEntity> {
    UserServiceEntity insert(InsertData insertData, Target target);

    default ListF<UserServiceEntity> find(String uid, Option<UUID> productOwnerId, Option<Target> target) {
        return find(uid,productOwnerId, target, Option.empty());
    }

    ListF<UserServiceEntity> find(String uid, Option<UUID> productOwnerId, Option<Target> target, Option<OrderStatus> orderStatus);

    ListF<UserServiceEntity> findUserServicesForCheck(Option<UUID> from, int batchSize);

    ListF<UserServiceEntity> findNotSynchronizedAt(Option<UUID> from, int batchSize, Instant syncDate);

    int countServicesWithCheckBillingDateBefore(Duration triggeredBefore);

    void stopAutoProlong(UUID id, Instant subscriptionUntil);

    void stopAutoProlong(UUID id);

    ListF<UUID> findActiveServicesByUserProduct(Option<UUID> fromUserServiceId, UUID userProductId, int batchSize);

    void updateSubscriptionStatus(UUID id, UserServiceBillingStatus status, Instant dueDate, Instant nextCheckDate);

    ListF<PassportUid> findActiveUids(ListF<PassportUid> uids);

    @Getter
    @Builder
    class InsertData extends DefaultObject implements InsertingData<UserServiceEntity> {
        private UUID userProductId;
        private String uid;
        private Option<Instant> nextCheckDate;
        private Option<Instant> dueDate;
        private UUID id;
        private Option<UUID> userProductPriceId;
        private Option<UserServiceBillingStatus> billingStatus;
        private Option<Boolean> autoProlongEnabled;
        private Option<UUID> paidByOrderId;
        private Option<String> packageName;
    }
}
