package ru.yandex.chemodan.app.psbilling.core.dao.users.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.dao.AbstractDaoImpl;
import ru.yandex.chemodan.app.psbilling.core.dao.users.UserInfoDao;
import ru.yandex.chemodan.app.psbilling.core.entities.users.UserInfo;
import ru.yandex.inside.passport.PassportUid;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

public class UserInfoDaoImpl extends AbstractDaoImpl<UserInfo> implements UserInfoDao {
    public UserInfoDaoImpl(JdbcTemplate3 jdbcTemplate) {
        super(jdbcTemplate);
    }

    @Override
    public String getTableName() {
        return "user_info";
    }

    @Override
    public UserInfo parseRow(ResultSet rs) throws SQLException {
        String region = rs.getString("region_id");
        return new UserInfo(
                UUID.fromString(rs.getString("id")),
                new Instant(rs.getTimestamp("created_at")),
                rs.getString("uid"),
                StringUtils.isNotEmpty(region) ? Option.of(region) : Option.empty()
        );
    }

    @Override
    public Option<UserInfo> lockUser(PassportUid uid) {
        return jdbcTemplate.query("select * from user_info where uid = ? for update", (rs, num) -> parseRow(rs),
                uid.toString())
                .firstO();
    }

    @Override
    public UserInfo createOrUpdate(InsertData dataToInsert) {
        Instant now = Instant.now();
        MapF<String, Object> params = Cf.hashMap();
        params.put("now", now);
        params.put("uid", dataToInsert.getUid().toString());
        params.put("region", dataToInsert.getRegionId() == null ? null : dataToInsert.getRegionId().getOrNull());

        return jdbcTemplate.query(
                "insert into user_info(created_at,uid,region_id) " +
                        "values(:now, :uid, :region ) " +
                        "ON CONFLICT(uid) DO UPDATE SET region_id=EXCLUDED.region_id " +
                        "RETURNING *",
                (rs, num) -> parseRow(rs), params).first();
    }

    @Override
    public Option<UserInfo> findByUid(PassportUid uid) {
        return jdbcTemplate.queryForOption("select * from user_info where uid = :uid",
                (rs, num) -> parseRow(rs), Cf.map("uid", uid.toString()));
    }
}
