package ru.yandex.chemodan.app.psbilling.core.entities;

import java.util.UUID;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.joda.time.Instant;

/**
 *  Entity c equals and hashcode только по Id (primary key).
 *  Чтобы не перебирать все поля при использовании в Set или Map
 */
public abstract class AbstractEntityWithIdEqHash extends AbstractEntity {
    public AbstractEntityWithIdEqHash(UUID id, Instant createdAt) {
        super(id, createdAt);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }

        if (!(o instanceof AbstractEntityWithIdEqHash)) {
            return false;
        }

        AbstractEntityWithIdEqHash that = (AbstractEntityWithIdEqHash) o;

        return new EqualsBuilder().append(getId(), that.getId()).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(getId()).toHashCode();
    }
}
