package ru.yandex.chemodan.app.psbilling.core.entities;

import lombok.Getter;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.products.BillingType;
import ru.yandex.chemodan.trust.client.InappStoreType;
import ru.yandex.misc.enums.StringEnum;

public enum InappStore implements StringEnum {
    APPLE_APPSTORE("APPLE_APPSTORE", InappStoreType.APPLE_APPSTORE, "App Store", BillingType.INAPP_APPLE),
    GOOGLE_PLAY("GOOGLE_PLAY", InappStoreType.GOOGLE_PLAY, "Google Play", BillingType.INAPP_GOOGLE);

    private final String value;
    private final InappStoreType trustInappStoreType;
    @Getter
    private final String humanReadable;
    @Getter
    private final BillingType billingType;

    InappStore(String value, InappStoreType trustInappStoreType, String humanReadable, BillingType billingType) {
        this.value = value;
        this.trustInappStoreType = trustInappStoreType;
        this.billingType = billingType;
        this.humanReadable = humanReadable;
    }

    @Override
    public String value() {
        return value;
    }

    public InappStoreType toTrustType() {
        return trustInappStoreType;
    }

    public static Option<InappStore> fromBillingType(BillingType billingType) {
        return Cf.list(values())
                .filter(inappStore -> inappStore.getBillingType().equals(billingType))
                .firstO();
    }
}

