package ru.yandex.chemodan.app.psbilling.core.entities.admin;

import java.util.Optional;
import java.util.UUID;

import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.chemodan.app.psbilling.core.entities.AbstractEntity;
import ru.yandex.inside.passport.PassportUid;

@SuppressWarnings("OptionalUsedAsFieldOrParameterType")
@Getter
public class InappMigration extends AbstractEntity {
    private final PassportUid uid;
    private final String status;
    private final UUID orderId;
    private final String currentProductPeriodCode;
    private final Optional<String> targetProductPeriodCode;

    public InappMigration(UUID id, Instant createdAt, PassportUid uid, String status, UUID orderId,
                          String currentProductPeriodCode, Optional<String> targetProductPeriodId) {
        super(id, createdAt);
        this.uid = uid;
        this.status = status;
        this.orderId = orderId;
        this.currentProductPeriodCode = currentProductPeriodCode;
        this.targetProductPeriodCode = targetProductPeriodId;
    }
}
