package ru.yandex.chemodan.app.psbilling.core.entities.cards;

import java.util.UUID;

import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.chemodan.app.psbilling.core.entities.AbstractEntity;
import ru.yandex.inside.passport.PassportUid;

@Getter
public class CardEntity extends AbstractEntity {
    private final PassportUid uid;
    private final CardPurpose purpose;
    private final String externalId;
    private final CardStatus status;
    private final Instant updatedAt;

    public CardEntity(UUID id, PassportUid uid, CardPurpose purpose, String externalId,
                      Instant createdAt, CardStatus status, Instant updatedAt)
    {
        super(id, createdAt);
        this.uid = uid;
        this.purpose = purpose;
        this.externalId = externalId;
        this.status = status;
        this.updatedAt = updatedAt;
    }
}
