package ru.yandex.chemodan.app.psbilling.core.entities.cards;

import java.util.UUID;

import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.AbstractEntity;
import ru.yandex.inside.passport.PassportUid;

@Getter
public class TrustCardBinding extends AbstractEntity {
    private CardBindingStatus status;
    private final PassportUid operatorUid;
    private final Option<String> transactionId;
    private Option<String> error;
    private Option<UUID> cardId;

    public TrustCardBinding(UUID id, Instant createdAt,
                            CardBindingStatus status, PassportUid operatorUid,
                            Option<String> transactionId,
                            Option<String> error, Option<UUID> cardId) {
        super(id, createdAt);
        this.status = status;
        this.error = error;
        this.transactionId = transactionId;
        this.operatorUid = operatorUid;
        this.cardId = cardId;
    }

    public TrustCardBinding withStatus(CardBindingStatus status) {
        this.status = status;
        return this;
    }

    public TrustCardBinding withError(Option<String> error) {
        this.error = error;
        return this;
    }

    public TrustCardBinding withCardId(Option<UUID> cardId) {
        this.cardId = cardId;
        return this;
    }
}
