package ru.yandex.chemodan.app.psbilling.core.entities.features;

import java.util.Map;
import java.util.UUID;

import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.entities.AbstractEntity;

@Getter
public class FeatureCallbackContext extends AbstractEntity {
    private final Option<String> uidO;
    private final Option<UUID> groupIdO;
    private final UUID featureId;
    private final Option<Map<String, Object>> data;

    public FeatureCallbackContext(UUID id, Instant createdAt, Option<String> uidO, Option<UUID> groupIdO,
                                  UUID featureId, Option<Map<String, Object>> data) {
        super(id, createdAt);
        this.uidO = uidO;
        this.groupIdO = groupIdO;
        this.featureId = featureId;
        this.data = data;
    }
}
