package ru.yandex.chemodan.app.psbilling.core.entities.features;

import java.util.UUID;

import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.synchronization.engine.SynchronizationStatus;
import ru.yandex.chemodan.app.psbilling.core.synchronization.engine.Target;

@Getter
public class GroupServiceFeature extends IssuedFeature<UUID> {
    public GroupServiceFeature(UUID id, Instant createdAt, Target target, Instant targetUpdatedAt,
                               SynchronizationStatus status, Instant statusUpdatedAt, Option<Instant> actualEnabledAt,
                               Option<Instant> actualDisabledAt, UUID groupServiceId, UUID productFeatureId,
                               UUID groupId, Option<Instant> nextTry, Option<UUID> productTemplateFeatureId) {
        super(id, createdAt, target, targetUpdatedAt, status, statusUpdatedAt, actualEnabledAt, actualDisabledAt,
                groupServiceId, productFeatureId, groupId, nextTry, productTemplateFeatureId);
    }

    public UUID getGroupServiceId() {
        return getParentServiceId();
    }

    public UUID getGroupId() {
        return getOwnerId();
    }
}
