package ru.yandex.chemodan.app.psbilling.core.entities.features;

import java.util.UUID;

import lombok.Getter;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.psbilling.core.synchronization.engine.SynchronizableRecord;
import ru.yandex.chemodan.app.psbilling.core.synchronization.engine.SynchronizationStatus;
import ru.yandex.chemodan.app.psbilling.core.synchronization.engine.Target;

@Getter
public abstract class IssuedFeature<TOwner> extends SynchronizableRecord {
    private final UUID parentServiceId;
    private final UUID productFeatureId;
    private final TOwner ownerId;
    private final Option<Instant> nextTry;
    private final Option<UUID> productTemplateFeatureId;

    protected IssuedFeature(UUID id, Instant createdAt, Target target, Instant targetUpdatedAt,
                            SynchronizationStatus status, Instant statusUpdatedAt,
                            Option<Instant> actualEnabledAt,
                            Option<Instant> actualDisabledAt, UUID parentServiceId, UUID productFeatureId,
                            TOwner ownerId,
                            Option<Instant> nextTry, Option<UUID> productTemplateFeatureId) {
        super(id, createdAt, target, targetUpdatedAt, status, statusUpdatedAt, actualEnabledAt, actualDisabledAt);
        this.parentServiceId = parentServiceId;
        this.productFeatureId = productFeatureId;
        this.ownerId = ownerId;
        this.nextTry = nextTry;
        this.productTemplateFeatureId = productTemplateFeatureId;
    }
}
